/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.IElementEntriesFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class BuildPathElementEntriesFilter
implements IElementEntriesFilter {
    private Set<IBuildPath> activeBuildPaths = new HashSet<IBuildPath>();
    private Set<IBuildPath> passiveBuildPaths = new HashSet<IBuildPath>();

    public BuildPathElementEntriesFilter(IModule module) {
        if (module != null) {
            IBuildPath buildPath = module.getBuildPath();
            if (buildPath == null) {
                this.activeBuildPaths = null;
                return;
            }
            if (buildPath.isPassive()) {
                this.passiveBuildPaths.add(buildPath);
            } else {
                this.activeBuildPaths.add(buildPath);
            }
            if (buildPath.getDependencies() != null) {
                for (IBuildPath dependency : buildPath.getDependencies()) {
                    if (dependency.isPassive()) {
                        this.passiveBuildPaths.add(dependency);
                        continue;
                    }
                    this.activeBuildPaths.add(dependency);
                }
            }
        } else {
            this.activeBuildPaths = null;
        }
    }

    @Override
    public Set<IElementEntry> filter(Collection<IElementEntry> toFilter) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        if (this.activeBuildPaths == null) {
            result.addAll(toFilter);
            return result;
        }
        LinkedHashSet<Integer> visitedEntries = new LinkedHashSet<Integer>();
        if (this.activeBuildPaths.size() != 0 || this.passiveBuildPaths.size() != 0) {
            block0: for (IElementEntry e : toFilter) {
                IModule module = e.getModule();
                boolean added = false;
                String entryPath = e.getEntryPath();
                int pathHash = entryPath != null ? entryPath.hashCode() : 0;
                int entryHash = pathHash + (module != null ? module.hashCode() : 0);
                if (!visitedEntries.contains(entryHash) && this.activeBuildPaths.size() != 0 && (module == null || this.activeBuildPaths.contains(module.getBuildPath()))) {
                    result.add(e);
                    added = true;
                    visitedEntries.add(entryHash);
                }
                if (this.passiveBuildPaths.size() == 0 || added) continue;
                for (IBuildPath passiveBuildPath : this.passiveBuildPaths) {
                    if (!passiveBuildPath.contains(module)) continue;
                    result.add(e);
                    continue block0;
                }
            }
        }
        return result;
    }
}

